\name{rho}
\alias{rho}
\title{
Pearson's correlation for two vector observations}
\usage{
rho(X,Y)
}
\arguments{
  \item{X}{An observed data vector from the first condition.}

  \item{Y}{An observed data vector from the second condition.}

}

\value{
  \item{rho}{A calculated Pearson's correlation value.}
}
\description{
This function calculates
the Pearson's correlation for
two vector observations
for the purpose of 
checking inner calculation.
}

\details{
Pearson's correlation for two vector observations.
}

\references{
Lim, J., Yu, D., Kuo, H., Choi, H., and Walmsely, S. (2019).
Truncated Rank Correlation as a robust
measure of test-retest reliability
in mass spectrometry data. Statistical Applications in Genetics and Molecular Biology, 18(4).
}

\examples{
%
p = 100
sig_z = 1.15
sig_e = 1
mu_z = 2
mu_e = 8
m0 = 30

S1 = rnorm(p,mean=mu_e,sd=sig_e)
S2 = rnorm(p,mean=mu_e,sd=sig_e)
    
if(m0!=0)
{
   X = mu_z + rnorm(m0,mean=0,sd=sig_z)
   indx = 1:p
   s_indx = sort(sample(indx,m0))
   S1[s_indx] = S1[s_indx] + X
   S2[s_indx] = S2[s_indx] + X
}
      
S1 = exp(S1)
S2 = exp(S2)

# Pearson's correlation
pcor = rho(S1,S2)
pcor
}

