\name{null_perm_m0}
\alias{null_perm_m0}
\title{
Procedure for estimating the null distribution of the TRC tau with a given m value}
\usage{
null_perm_m0(X,Y,nperm=1000,m=5,seed=21)
}
\arguments{
  \item{X}{An observed data vector from the first condition.}

  \item{Y}{An observed data vector from the second condition.}

  \item{nperm}{the number of permutations to estimate the null distribution (default: 1000).}
  
  \item{m}{A rank threshold for the calculation of TRC tau (default: 5).}
    
  \item{seed}{An initial seed for the permutation.}
}

\value{
  \item{perm_tau}{A vector of calculated TRC tau values from the permuted samples}

}
\description{
 Procedure for estimating the null distribution of the TRC tau with a given m value.
}

\details{
Null distribution of the TRC tau with a given
m value is estimated by the permuted samples.
}

\references{
Lim, J., Yu, D., Kuo, H., Choi, H., and Walmsely, S. (2019).
Truncated Rank Correlation as a robust
measure of test-retest reliability
in mass spectrometry data. Statistical Applications in Genetics and Molecular Biology, 18(4).
}

\examples{
%
p = 100
sig_z = 1.15
sig_e = 1
mu_z = 2
mu_e = 8
m0 = 30

S1 = rnorm(p,mean=mu_e,sd=sig_e)
S2 = rnorm(p,mean=mu_e,sd=sig_e)
    
if(m0!=0)
{
   X = mu_z + rnorm(m0,mean=0,sd=sig_z)
   indx = 1:p
   s_indx = sort(sample(indx,m0))
   S1[s_indx] = S1[s_indx] + X
   S2[s_indx] = S2[s_indx] + X
}
      
S1 = exp(S1)
S2 = exp(S2)

null_res = null_perm_m0(S1,S2,nperm=1000,m=5,seed=21)

}

