\name{null_perm}
\alias{null_perm}
\title{
Procedure for estimating the null distribution of the TRC tau with the m value chosen by the proposed rule.}
\usage{
null_perm(X,Y,nperm=1000,start=3,range_m=0.5,span=0.5,seed=21,all_m=FALSE)
}
\arguments{
  \item{X}{An observed data vector from the first condition.}

  \item{Y}{An observed data vector from the second condition.}

  \item{nperm}{the number of permutations to estimate the null distribution (default: 1000).}
  
  \item{start}{A lower bound of a search region for the threshold rank m (default: 3).}
  
  \item{range_m}{A proportion of length of X for specifying the end of the search region for m
  (default: 0.8).}
    
  \item{span}{A parameter alpha which controls the degree of smoothing in loess function.}
  
  \item{seed}{An initial seed for the permutation.}

  \item{all_m}{a logical flag for returning permuted TRC tau values for all m values (default: FALSE).}
}

\value{
  \item{perm_trc}{A vector of TRC tau values from the permuted samples with the m value chosen by the proposed rule.}

  \item{hist_m}{A vector of the chosen m values for permutations.}

  \item{perm_ktau}{A vector of Kendall's tau values from the permuted samples.}

  \item{perm_rho}{A vector of Pearson's correlation values from the permuted samples.}

  \item{perm_trc_all_m}{A matrix of permuted TRC tau values for all m values, in which each column stores the permuted TRC tau values for corresponding m value.}

}
\description{
 Procedure for estimating the null distribution of the TRC tau with the m value chosen by the proposed rule.
}

\details{
Null distributions of the TRC tau with a given
m value, the Kendall's tau, and 
Pearson's correlation are
estimated by the permuted samples.
}

\references{
Lim, J., Yu, D., Kuo, H., Choi, H., and Walmsely, S. (2019).
Truncated Rank Correlation as a robust
measure of test-retest reliability
in mass spectrometry data. Statistical Applications in Genetics and Molecular Biology, 18(4).
}

\examples{
%
p = 100
sig_z = 1.15
sig_e = 1
mu_z = 2
mu_e = 8
m0 = 30

S1 = rnorm(p,mean=mu_e,sd=sig_e)
S2 = rnorm(p,mean=mu_e,sd=sig_e)
    
if(m0!=0)
{
   X = mu_z + rnorm(m0,mean=0,sd=sig_z)
   indx = 1:p
   s_indx = sort(sample(indx,m0))
   S1[s_indx] = S1[s_indx] + X
   S2[s_indx] = S2[s_indx] + X
}
      
S1 = exp(S1)
S2 = exp(S2)

null_res = null_perm(S1,S2,nperm=1000,start=3,range_m=0.5,span=0.2,seed=21,all_m=FALSE)

}

