% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateTrawl.R
\name{sim_BivariateTrawl}
\alias{sim_BivariateTrawl}
\title{Simulates a bivariate trawl process}
\usage{
sim_BivariateTrawl(
  t,
  Delta = 1,
  burnin = 10,
  marginal = base::c("Poi", "NegBin"),
  dependencetype = base::c("fullydep", "dep"),
  trawl1 = base::c("Exp", "DExp", "supIG", "LM"),
  trawl2 = base::c("Exp", "DExp", "supIG", "LM"),
  v1 = 0,
  v2 = 0,
  v12 = 0,
  kappa1 = 0,
  kappa2 = 0,
  kappa12 = 0,
  a1 = 0,
  a2 = 0,
  lambda11 = 0,
  lambda12 = 0,
  w1 = 0,
  delta1 = 0,
  gamma1 = 0,
  alpha1 = 0,
  H1 = 0,
  lambda21 = 0,
  lambda22 = 0,
  w2 = 0,
  delta2 = 0,
  gamma2 = 0,
  alpha2 = 0,
  H2 = 0
)
}
\arguments{
\item{t}{parameter which specifying the length of the time interval
\eqn{[0,t]} for which a simulation of the trawl process is required.}

\item{Delta}{parameter \eqn{\Delta} specifying the length of the time step,
the default is 1}

\item{burnin}{parameter specifying the length of the burn-in period at the
beginning of the simulation}

\item{marginal}{parameter specifying the marginal distribution of the trawl}

\item{dependencetype}{Parameter specifying the type of dependence}

\item{trawl1}{parameter specifying the type of the first trawl function}

\item{trawl2}{parameter specifying the type of the second trawl function}

\item{v1, v2, v12}{parameters of the Poisson distribution}

\item{kappa1, kappa2, kappa12, a1, a2}{parameters of the (possibly bivariate)
negative binomial distribution}

\item{lambda11, lambda12, w1}{parameters of the exponential (or
double-exponential) trawl function of the first process}

\item{delta1, gamma1}{parameters of the supIG trawl function of the first
process}

\item{alpha1, H1}{parameter of the long memory trawl of the first process}

\item{lambda21, lambda22, w2}{parameters of the exponential (or
double-exponential) trawl function of the second process}

\item{delta2, gamma2}{parameters of the supIG trawl function of the second
process}

\item{alpha2, H2}{parameter of the long memory trawl of the second process}
}
\description{
Simulates a bivariate trawl process
}
\details{
This function simulates a bivariate trawl process with either Poisson
 or negative binomial marginal law. For the trawl function there are
 currently four choices: exponential, double-exponential, supIG or long
 memory. More details on the precise simulation algorithm is available in the
 vignette.
}
