% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trait_missing.R
\name{trait_missing}
\alias{trait_missing}
\title{Which taxa lack traits}
\usage{
trait_missing(filled_trait, comm)
}
\arguments{
\item{filled_trait}{output of trait_fill function.}

\item{comm}{community data}
}
\value{
A \code{tibble} with columns
#' \itemize{
\item{Taxon }{Species names (actual name depends on \code{taxon_col}
argument to \code{trait_fill()})}
\item{max_abun }{Maximum abundance of that taxa.
Be more concerned about taxa missing traits with high abundances.}
\item{n }{Number of occurrences of the taxon.
Be more concerned about taxa missing traits with many occurrences.}
\item{n_traits }{Number of traits for each species.
Ideally all should equal the number of traits you have measured.}
}
}
\description{
Function gives overview of which taxa are missing traits.
}
\examples{
data(community)
data(trait)
filled_traits <- trait_fill(
  comm = community, traits = trait,
  scale_hierarchy = c("Site", "PlotID"),
  taxon_col = "Taxon", value_col = "Value",
  trait_col = "Trait", abundance_col = "Cover"
)
trait_missing(filled_traits, community)
}
