% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_serialise.R
\name{isDeserialisable}
\alias{isDeserialisable}
\alias{serialisation}
\alias{serialiseReferenceObject}
\alias{deserialiseReferenceObject}
\alias{registerDeserialiser}
\title{Reference object serialisation and deserialisation}
\usage{
isDeserialisable(object, expectedClass = NULL)

serialiseReferenceObject(object, file = NULL)

deserialiseReferenceObject(file = NULL, object = NULL, raw = FALSE)

registerDeserialiser(className, deserialiser)
}
\arguments{
\item{object}{For \code{serialiseReferenceObject}, any object, but only
those inheriting from \code{\linkS4class{SerialisableObject}} and
\code{\link{loso}} objects are treated specially. For other functions, an
object in (raw) serialised form. See Details.}

\item{expectedClass}{A class name which the object is expected to inherit.
Any class is acceptable if this parameter is \code{NULL}.}

\item{file}{A file name to deserialise from.}

\item{raw}{If \code{TRUE}, the raw serialised object is returned; otherwise
the object is converted back to its original class.}

\item{className}{A string naming a class to be handled by the specified
deserialiser.}

\item{deserialiser}{A function taking as its argument a list of serialised
fields, and returning a suitable deserialised object.}
}
\value{
\code{isDeserialisable} returns \code{TRUE} if the \code{object} is
  deserialisable and (if specified) inherits from the required class,
  otherwise \code{FALSE}. If its argument is serialisable then
  \code{serialiseReferenceObject} returns the serialised version, invisibly;
  otherwise it returns the unmodified object, again invisibly.
  \code{deserialiseReferenceObject} returns a raw or reconstituted object
  after deserialisation.
}
\description{
Rather than using R's \code{\link{save}} and \code{\link{load}} functions
directly for reference objects, TractoR uses the
\code{\linkS4class{SerialisableObject}} class and these functions to save
and load objects. The main difference is that this approach stores only the
data in the object, and not the functions which operate on them. This helps
backward compatibility when new member functions are added.
}
\details{
The \code{serialiseReferenceObject} function, or the \code{serialise} member
function of the \code{\link{SerialisableObject}} class, can be used to
create and/or \code{\link{save}} a version of an object which contains a
hierarchical representation of the data embedded in it. These serialised
objects are standard R lists, with an \code{"originalClass"} attribute
describing the class of the original object. The
\code{deserialiseReferenceObject} function can be used to deserialise them.
Custom deserialisers can be specified using \code{registerDeserialiser},
typically for legacy classes.

Note that this should generally NOT be used as the primary mechanism for
saving and loading \code{\link{MriImage}} objects. Saving to standard
NIfTI/Analyze format is usually preferable, and can be done using
\code{\link{writeImageFile}}.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18. \doi{10.18637/jss.v044.i08}.
}
\seealso{
\code{\linkS4class{SerialisableObject}}, \code{\link{save}},
\code{\link{load}}, \code{\link{loso}}, \code{\link{writeImageFile}}.
}
\author{
Jon Clayden
}
