% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{phed}
\alias{phed}
\title{Calculate PHED Metric}
\usage{
phed(
  travel_time_readings,
  tmc_identification,
  speed_limits,
  urban_code = NA,
  pm_peak = 3,
  avo_cars = 1.7,
  avo_trucks = 1,
  avo_buses = 10.7,
  moy_factor = moy_factor_default,
  dow_factor = dow_factor_default,
  hod_profile = hod_profile_default,
  population = NA
)
}
\arguments{
\item{travel_time_readings}{path to readings CSV with 15-minute travel time observations for all vehicles exported from RITIS.}

\item{tmc_identification}{Path to TMC_Identification.csv file provided by RITIS with travel time download.}

\item{speed_limits}{a data.frame-like object with speed limits for all TMCs with format tmc,speed_limit}

\item{urban_code}{optional vector of one (or more) urban_code values. if specified, filters TMCs to the relevant urban_code}

\item{pm_peak}{3 or 4. Peak Period is defined as weekdays from 6 am to 10 am and either 3 pm to 7 pm (3) or 4 pm to 8 pm (4)}

\item{avo_cars}{Average vehicle occupancy for passenger vehicles}

\item{avo_trucks}{Average vehicle occupancy for freight trucks}

\item{avo_buses}{Average vehicle occupancy for buses}

\item{moy_factor}{Month of year traffic adjustment factors for freeways and non-freeway facilities in format \preformatted{month,freeway,non_freeway
1, 0.99, 0.98
... 
12, 1.01, 1.00}}

\item{dow_factor}{Day of week adjustment factors. Monday (2) through Friday (6). Format: \preformatted{day,freeway,non_freeway
2, 1.05, 1.05
...
6, 1.1, 1.1}}

\item{hod_profile}{Hourly traffic percentages for peak hours. Non-directional. Format: \preformatted{hour,freeway,non_freeway
6,0.045,0.050
...
18,0.052,0.048}}

\item{population}{Optional population value. If provided, function will print PHED value}
}
\value{
Annual hours of peak hour excessive delay per capita
}
\description{
Calculate the CMAQ Traffic Congestion Measure in accordance with
\href{https://www.fhwa.dot.gov/tpm/guidance/hif18040.pdf}{FHWA General Guidance and Step-by-Step Metric Calculation Procedures for National Performance Measures for Congestion, Reliability, and Freight, and CMAQ Traffic Congestion}
Requires the speed limits for all TMC segments. Other parameters are optional
and (with defaults supplied from  FHWA's guidance). Uses the same travel time readings
file as \code{score(..., metric = "LOTTR")}. Outputs annual hours of delay.
}
\examples{
\dontrun{
phed(travel_time_readings = "npmrds/all_vehicles_2021/Readings.csv",
     tmc_identification = "npmrds/all_vehicles_2021/TMC_Identification.csv", 
     speed_limits = fread("birmingham_tmc_speed_limits.csv"), 
     urban_code = 7786,
     pm_peak = 3, 
     output_file_name = "phed_2021.csv",
     avo_cars = 1.62, avo_trucks = 1.0, avo_buses = 5.1,
     moy_factor = fread("birmingham_moy_factors.csv"), 
     dow_factor = fread("birmingham_dow_factors.csv"), 
     hod_profile = fread("birmingham_hod_profile.csv"),
     population = 752898)
}

}
