% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R
\name{update_docstring}
\alias{update_docstring}
\title{Update docstring for a Function}
\usage{
update_docstring(uri, func, content = NULL)
}
\arguments{
\item{uri}{Path to R file.}

\item{func}{Function name. If a function is defined multiple times inside the
provided file, only the last occurence will be considered.}

\item{content}{R code as string. If provided, uri is ignored.}
}
\value{
A character vector of length 1 containing the updated docstring.
}
\description{
The \href{https://roxygen2.r-lib.org/}{roxygen2} package makes it
possible to write documentation for R functions directly above the
corresponding function. This function can be used to update the parameter
list of a documentation string (docstring) of a valid function of a valid R
file. The update is done by comparing the currently listed parameters with
the actual function parameters. Outdated parameters are removed and missing
parameters are added to the docstring.
}
\examples{
uri <- system.file("testfiles/funcs.R", package = "toscutil")
func <- "f4"
update_docstring(uri, func)
}
\keyword{doc}
