% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topoLCP.R
\name{topoLCP}
\alias{topoLCP}
\title{Topographic least cost paths and distances}
\usage{
topoLCP(DEM, costSurface, pts, directions = 8, paths = FALSE, zweight = 1)
}
\arguments{
\item{DEM}{A RasterLayer for digital elevation model (DEM) data.}

\item{costSurface}{A RasterLayer for the conductance (inverse of resistance) values for each cell.}

\item{pts}{A SpatialPoints object or two-column matrix with xy coordinates for the geographic points from which to calculate pairwise distances and paths.}

\item{directions}{numeric (default = 8). The number of directions for movement between cells, either 4 or 8.}

\item{paths}{logical. Default is FALSE, in which case only topographic distances are calculated.  If TRUE, topographic paths are also identified.}

\item{zweight}{numeric (default = 1). The weight to be applied to the elevation (z) distances relative to the horizontal (xy) distances.}
}
\value{
Matrix of topographic distances (if paths = FALSE), or a list containing a matrix of topographic distances and the topographic paths as an object of class SpatialLines (if paths = TRUE).
}
\description{
Calculates topographic least cost distances and paths
}
\details{
The values of the raster for costSurface should be conductance values rather than resistance values.  These can be calculating by taking the inverse of resistance values.
}
\examples{
xy <- matrix(ncol = 2, byrow = TRUE,
   c(-119.5566, 37.72474,
   -119.4718, 37.76078))
topoLCP(Yosemite$DEM, Yosemite$SDM, xy, paths = TRUE)
}
