% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectInfo.R
\name{effectInfo}
\alias{effectInfo}
\alias{print.effectInfo}
\title{Interpretation of Effects in Linear, Logistic and Poisson Models with
Transformed Variables}
\usage{
effectInfo(object)

\method{print}{effectInfo}(x, ...)
}
\arguments{
\item{object}{object of class "\code{tlm}" obtained with the function \code{\link{tlm}}.}

\item{x}{for \code{print.effectInfo}, an object of class "\code{effectInfo}" (an output
of the \code{effectInfo} function).}

\item{\dots}{additional arguments for \code{print.effectInfo}.}
}
\value{
A list with class "\code{effectInfo}" including the following items:
\describe{
\item{beta}{regression coefficient estimate in the fitted model which is
associated to the effect of the explanatory variable of interest on the
response variable. \code{NA} corresponds to those models for which a
summary effect does not exist.}
\item{Xincrease}{type of change in the exploratory variable of interest
(additive or realtive) for which a summary effect exists. \code{NA}
corresponds to those models for which a summary effect does not exist.}
\item{effecttype}{type of effect on the response variable for which a
summary effect exists. \code{NA} corresponds to those models for which a
summary effect is not available.}
\item{effectsize}{formula for the summary effect size, if any. \code{NA}
corresponds to those models for which a summary effect is not available.}
\item{furtherinfo}{further information about how to interpret effects.}
}
}
\description{
Provides information on interpreting effects in linear, logistic
and Poisson models with transformed variables. Specifically, if a summary
measure for the effect exists, the function details how to obtain and interpret it.
}
\examples{
### Linear model with log transformation in the explanatory variable:
data(cotinine)
head(cotinine)
# model fitting:
modcot <- tlm(weight ~ logcotinine, data = cotinine, xpow = 0)
modcot
# information on interpreting the effect:
effectInfo(modcot)

### Linear model with no summary measure of effect:
data(glucose)
head(glucose)
# transformations Y^(-2) and X^(-1/2): 
modgluco <- tlm(inv2glu ~ inv12tri, data = glucose, ypow = -2, xpow = -1/2)
modgluco
effectInfo(modgluco)
}
\references{
Barrera-Gomez J, Basagana X. Models with transformed variables:
interpretation and software. \emph{Epidemiology}. 2015;26(2):e16-17.
}
\seealso{
\code{\link{tlm}}, \code{\link{effect}}, \code{\link{MY}}.
}
