% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taper_kozak.R
\name{taper_kozak}
\alias{taper_kozak}
\title{Kozak (2004) Taper Function.}
\usage{
taper_kozak(dbh, h, hih, b0, b1, b2, b3, b4, b5, b6, b7, b8, p)
}
\arguments{
\item{dbh}{tree diameter at breast height, in centimeters.}

\item{h}{total tree height, in meters.}

\item{hih}{ratio between the height of the section (hi) and the total height (h) .}

\item{b0, b1, b2, b3, b4, b5, b6, b7, b8}{model parameters.}

\item{p}{numerical value representing the first inflection point calculated in the segmented model of Max and Burkhart (1976).}
}
\value{
a numeric value indicating the diameter at the section.
}
\description{
Kozak (2004) Taper Function.
}
\examples{

library(dplyr)
library(minpack.lm)
library(timbeR)

tree_scaling <- tree_scaling \%>\%
mutate(did = di/dbh,
       hih = hi/h)

kozak <-  nlsLM(di ~ taper_kozak(dbh, h, hih, b0, b1, b2, b3, b4, b5, b6, b7, b8, p),
data=tree_scaling,
start=list(b0=1.00,b1=.97,b2=.03,b3=.49,b4=-0.87,b5=0.50,b6=3.88,b7=0.03,b8=-0.19,p =.1))

}
\references{
Kozak, A. (2004). My last words on taper equations. The Forestry Chronicle, 80(4), 507-515.
}
