% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_weather.R
\name{write_weather}
\alias{write_weather}
\title{Write weather data to file}
\usage{
write_weather(records, file, format = "APSIM", overwrite = FALSE)
}
\arguments{
\item{records}{A data frame containing weather data with columns for date,
temperature, precipitation, and other meteorological variables}

\item{file}{Character string specifying the output file path}

\item{format}{Character string specifying the output format. Currently
supports "APSIM" (default)}

\item{overwrite}{Logical indicating whether to overwrite existing files.
Default is FALSE}
}
\value{
Invisibly returns the file path of the written file
}
\description{
Exports weather records to a file in the specified format. Currently supports
APSIM format for agricultural modeling applications.
}
\examples{
# Read sample weather data from package
file <- system.file("extdata/ppd_72150.met", package = "tidyweather")
records <- read_weather(file)

# Write to temporary file
temp_file <- tempfile(fileext = ".met")

# Write to APSIM format
write_weather(records, temp_file, format = "APSIM")

# Overwrite existing file
write_weather(records, temp_file, format = "APSIM", overwrite = TRUE)

}
