% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_admix_methods.R
\name{c.gt_admix}
\alias{c.gt_admix}
\title{Combine method for gt_admix objects}
\usage{
\method{c}{gt_admix}(..., match_attributes = TRUE)
}
\arguments{
\item{...}{A list of \code{gt_admix} objects}

\item{match_attributes}{boolean, determining whether all attributes (id,
group and algorithm) of the \code{gt_admix} objects to be combined must be an
exact match (TRUE, the default), or whether non-matching attributes should
be ignored (FALSE)}
}
\value{
A \code{gt_admix} object with the combined data
}
\description{
Combine method for gt_admix objects
}
\examples{
# run the example only if we have the package installed
if (requireNamespace("LEA", quietly = TRUE)) {
  example_gt <- load_example_gt("gen_tbl")

  # Create a gt_admix object
  admix_obj <- example_gt \%>\% gt_snmf(k = 1:3, project = "force")

  # Create a second gt_admix object
  admix_obj2 <- example_gt \%>\% gt_snmf(k = 2:4, project = "force")

  # Combine the two gt_admix objects
  new_admix_obj <- c(admix_obj, admix_obj2)
  summary(new_admix_obj)
}
}
