% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyper_array.R
\name{hyper_array}
\alias{hyper_array}
\alias{tidync_data}
\alias{hyper_slice}
\alias{hyper_array.tidync}
\alias{hyper_array.character}
\title{Extract NetCDF data as an array}
\usage{
hyper_array(
  x,
  select_var = NULL,
  ...,
  raw_datavals = FALSE,
  force = FALSE,
  drop = TRUE
)

hyper_slice(
  x,
  select_var = NULL,
  ...,
  raw_datavals = FALSE,
  force = FALSE,
  drop = TRUE
)

\method{hyper_array}{tidync}(
  x,
  select_var = NULL,
  ...,
  raw_datavals = FALSE,
  force = FALSE,
  drop = TRUE
)

\method{hyper_array}{character}(
  x,
  select_var = NULL,
  ...,
  raw_datavals = FALSE,
  force = FALSE,
  drop = TRUE
)
}
\arguments{
\item{x}{NetCDF file, connection object, or \link{tidync} object}

\item{select_var}{optional vector of variable names to select}

\item{...}{passed to \code{\link[=hyper_filter]{hyper_filter()}}}

\item{raw_datavals}{logical to control whether scaling in the NetCDF is
applied or not}

\item{force}{ignore caveats about large extraction and just do it}

\item{drop}{collapse degenerate dimensions, defaults to \code{TRUE}}
}
\description{
Extract the raw array data as a list of  one or more arrays. This can be the
entire variable/s or after dimension-slicing using \code{\link[=hyper_filter]{hyper_filter()}}
expressions. This is a delay-breaking function and causes data to be read
from the source into R native arrays. This list of arrays is
lightly classed as \link{tidync_data}, with methods for \code{\link[=print]{print()}} and \code{\link[=tidync]{tidync()}}.
}
\details{
The function \code{\link[=hyper_array]{hyper_array()}} is used by \code{\link[=hyper_tibble]{hyper_tibble()}} and \code{\link[=hyper_tbl_cube]{hyper_tbl_cube()}}
to actually extract data arrays from NetCDF, if a result would be particularly large
there is a check made and user-opportunity to cancel. This is controllable as an
option \code{getOption('tidync.large.data.check')}, and can be set to never check with
\code{options(tidync.large.data.check = FALSE)}.

The function \code{\link[=hyper_array]{hyper_array()}} will act on an existing tidync object or a source
string.

By default all variables in the active grid are returned, use \code{select_var} to
specify one or more desired variables.

The transforms are stored as a list of tables in an attribute `transforms``,
access these with \code{\link[=hyper_transforms]{hyper_transforms()}}.
}
\examples{
f <- "S20080012008031.L3m_MO_CHL_chlor_a_9km.nc"
l3file <- system.file("extdata/oceandata", f, package= "tidync")

## extract a raw list by filtered dimension
library(dplyr)
araw1 <- tidync(l3file) \%>\%
 hyper_filter(lat = between(lat, -78, -75.8), 
              lon = between(lon, 165, 171)) \%>\%
 hyper_array()

araw <- tidync(l3file) \%>\% 
         hyper_filter(lat = abs(lat) < 10, 
                     lon = index < 100) \%>\%
  hyper_array()

## hyper_array will pass the expressions to hyper_filter
braw <- tidync(l3file) \%>\% 
  hyper_array(lat = abs(lat) < 10, lon = index < 100)

## get the transforms tables (the axis coordinates)
lapply(attr(braw, "transforms"), 
   function(x) nrow(dplyr::filter(x, selected)))
## the selected axis coordinates should match in order and in size
lapply(braw, dim)
}
\seealso{
\link{print.tidync_data} for a description of the print summary,
\code{\link[=hyper_tbl_cube]{hyper_tbl_cube()}} and \code{\link[=hyper_tibble]{hyper_tibble()}} which are also delay-breaking
functions that cause data to be read
}
