% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row.R
\name{row-functions}
\alias{row-functions}
\alias{rowMeans}
\alias{rowSums}
\title{NA-aware Row-wise Functions}
\usage{
rowMeans(x, na.rm = TRUE, all_na = NULL, dims = 1L, ...)

rowSums(x, na.rm = TRUE, all_na = NULL, dims = 1L, ...)
}
\arguments{
\item{x}{A numeric matrix or data frame.}

\item{na.rm}{Logical. Should missing values be removed? Default \code{TRUE}.}

\item{all_na}{Character. What to do when all values are NA:
\code{"error"} (default) throws an error, \code{"base"} returns what base R does
with \code{na.rm = TRUE} (\code{NaN} for \code{rowMeans()}, \code{0} for \code{rowSums()}),
\code{"na"} returns \code{NA}. If \code{NULL}, uses \code{getOption("tidyna.all_na", "error")}.}

\item{dims}{Integer. Number of dimensions to treat as rows.}

\item{...}{Additional arguments passed to the base function.}
}
\value{
A numeric or complex array of suitable size, or a vector if the
result is one-dimensional.
}
\description{
Drop-in replacements for \code{rowMeans()} and \code{rowSums()} that default to
\code{na.rm = TRUE}. Both return \code{NA} for rows where ALL values are missing
(base \code{rowMeans()} returns \code{NaN}, base \code{rowSums()} returns \code{0}).
}
\examples{
mat <- matrix(c(1, NA, 3, NA, NA, NA), nrow = 2, byrow = TRUE)
rowSums(mat)

# Compare to base R:
base::rowSums(mat, na.rm = TRUE)

}
