% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature-indices.R
\name{calculate_TXx}
\alias{calculate_TXx}
\title{Calculate monthly maximum value of daily maximum temperature (TXx)}
\usage{
calculate_TXx(
  df,
  frequency = "daily",
  time_col = NULL,
  tmax_col = NULL,
  temp_col = NULL,
  min_days = 20
)
}
\arguments{
\item{df}{Data frame with climate data}

\item{frequency}{Temporal frequency: "daily" or "hourly"}

\item{time_col}{Name of the time column. For daily frequency, the column should be
of class Date or a string in the format YYYY-MM-DD. For hourly frequency, the column
should be of class POSIXct or a string in the format YYYY-MM-DD HH:MM:SS.}

\item{tmax_col}{Name of maximum temperature column (daily data)}

\item{temp_col}{Name of temperature column (for single temp or hourly)}

\item{min_days}{Minimum days per month for valid calculation (default: 20)}
}
\value{
A tibble with columns: year, month, TXx
}
\description{
Calculates the highest daily maximum temperature for each month,
following ETCCDI definition TXx.
}
\examples{
# Daily data with maximum temperature
daily_data <- data.frame(
  date = seq(as.Date("2000-01-01"), as.Date("2002-12-31"), by = "day"),
  tmax = rnorm(1096, mean = 25, sd = 6)
)

calculate_TXx(
  df = daily_data,
  frequency = "daily",
  time_col = "date",
  tmax_col = "tmax"
)

# With custom minimum days per month
calculate_TXx(
  df = daily_data,
  frequency = "daily",
  time_col = "date",
  tmax_col = "tmax",
  min_days = 25
)
}
