% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature-indices.R
\name{calculate_TX25}
\alias{calculate_TX25}
\title{Calculate number of summer days (TX > 25\eqn{^\circ}{}C)}
\usage{
calculate_TX25(
  df,
  frequency = "daily",
  time_col = NULL,
  tmax_col = NULL,
  temp_col = NULL,
  threshold = 25
)
}
\arguments{
\item{df}{Data frame with climate data}

\item{frequency}{Temporal frequency: "daily" or "hourly"}

\item{time_col}{Name of the time column. For daily frequency, the column should be
of class Date or a string in the format YYYY-MM-DD. For hourly frequency, the column
should be of class POSIXct or a string in the format YYYY-MM-DD HH:MM:SS.}

\item{tmax_col}{Name of maximum temperature column (daily data)}

\item{temp_col}{Name of temperature column (for single temp or hourly)}

\item{threshold}{Temperature threshold in \eqn{^\circ}{}C (default: 25)}
}
\value{
A tibble with columns: year, TX25
}
\description{
Counts the number of days per year when daily maximum temperature
exceeds 25\eqn{^\circ}{}C, following ETCCDI definition SU25.
}
\examples{
# Daily data with separate max/min
daily_data <- data.frame(
  date = seq(as.Date("2000-01-01"), as.Date("2002-12-31"), by = "day"),
  tmax = rnorm(1096, mean = 25, sd = 6)
)

calculate_TX25(
  df = daily_data,
  frequency = "daily",
  time_col = "date",
  tmax_col = "tmax"
)

# Hourly data
hourly_data <- data.frame(
  datetime = seq(
    as.POSIXct("2000-01-01 00:00", tz = "UTC"),
    as.POSIXct("2000-01-31 23:00", tz = "UTC"),
    by = "hour"
  ),
  temperature = rnorm(31*24, mean = 22, sd = 4)
)

calculate_TX25(
  df = hourly_data,
  frequency = "hourly",
  time_col = "datetime",
  temp_col = "temperature",
  threshold = 25
)

}
