% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature-indices.R
\name{calculate_TR20}
\alias{calculate_TR20}
\title{Calculate number of tropical nights (TN > 20\eqn{^\circ}{}C)}
\usage{
calculate_TR20(
  df,
  frequency = "daily",
  time_col = NULL,
  tmin_col = NULL,
  temp_col = NULL,
  threshold = 20
)
}
\arguments{
\item{df}{Data frame with climate data}

\item{frequency}{Temporal frequency: "daily" or "hourly"}

\item{time_col}{Name of the time column. For daily frequency, the column should be
of class Date or a string in the format YYYY-MM-DD. For hourly frequency, the column
should be of class POSIXct or a string in the format YYYY-MM-DD HH:MM:SS.}

\item{tmin_col}{Name of minimum temperature column (daily data)}

\item{temp_col}{Name of temperature column (for single temp or hourly)}

\item{threshold}{Temperature threshold in \eqn{^\circ}{}C (default: 20)}
}
\value{
A tibble with columns: year, TR20
}
\description{
Counts the number of days per year when daily minimum temperature
exceeds 20\eqn{^\circ}{}C, following ETCCDI definition TR20.
}
\examples{
# Daily data with separate min temperature
daily_data <- data.frame(
  date = seq(as.Date("2000-01-01"), as.Date("2002-12-31"), by = "day"),
  tmin = rnorm(1096, mean = 18, sd = 5)
)

calculate_TR20(
  df = daily_data,
  frequency = "daily",
  time_col = "date",
  tmin_col = "tmin"
)

# Hourly data (will be aggregated to daily min temperature)
hourly_data <- data.frame(
  datetime = seq(
    as.POSIXct("2000-01-01 00:00", tz = "UTC"),
    as.POSIXct("2000-01-31 23:00", tz = "UTC"),
    by = "hour"
  ),
  temperature = rnorm(31*24, mean = 16, sd = 3)
)

calculate_TR20(
  df = hourly_data,
  frequency = "hourly",
  time_col = "datetime",
  temp_col = "temperature",
  threshold = 20
)
}
