% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_spec.R, R/sql_dataset.R
\name{sql_record_spec}
\alias{sql_record_spec}
\alias{sql_dataset}
\alias{sqlite_dataset}
\title{A dataset consisting of the results from a SQL query}
\usage{
sql_record_spec(names, types)

sql_dataset(driver_name, data_source_name, query, record_spec)

sqlite_dataset(filename, query, record_spec)
}
\arguments{
\item{names}{Names of columns returned from the query}

\item{types}{List of \code{tf$DType} objects (e.g. \code{tf$int32},
\code{tf$double}, \code{tf$string}) representing the types of the columns
returned by the query.}

\item{driver_name}{String containing the database type. Currently, the only
supported value is 'sqlite'.}

\item{data_source_name}{String containing a connection string to connect to
the database.}

\item{query}{String containing the SQL query to execute.}

\item{record_spec}{Names and types of database columns}

\item{filename}{Filename for the database}
}
\value{
A dataset
}
\description{
A dataset consisting of the results from a SQL query
}
