% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfm.R
\name{diagchk.tfm}
\alias{diagchk.tfm}
\title{Diagnostic Checking for Transfer Function Models}
\usage{
\method{diagchk}{tfm}(
  mdl,
  y = NULL,
  method = c("exact", "cond"),
  lag.max = NULL,
  lags.at = NULL,
  freq.at = NULL,
  std = TRUE,
  envir = NULL,
  ...
)
}
\arguments{
\item{mdl}{A fitted \code{tfm} object.}

\item{y}{Optional \code{ts} object for alternative output series.}

\item{method}{Character: "exact" or "cond" for residual calculation.}

\item{lag.max}{Maximum lag for ACF/PACF plots.}

\item{lags.at}{Specific lags to display in ACF/PACF.}

\item{freq.at}{Specific frequencies for cumulative periodogram.}

\item{std}{Logical. If TRUE, standardizes residuals.}

\item{envir}{Environment for evaluation. NULL uses calling environment.}

\item{...}{Additional arguments passed to \code{\link{ide}}.}
}
\description{
Produces diagnostic plots for residuals of a fitted transfer function model.
}
\details{
Generates five diagnostic plots: time series plot of residuals, 
histogram, ACF, PACF, and cumulative periodogram. Uses the \code{\link{ide}}
function for plotting.
}
\seealso{
\code{\link{tfm}}, \code{\link{tsdiag.tfm}}
}
