% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm.R, R/ucarima.R, R/um.R
\name{diagchk.ssm}
\alias{diagchk.ssm}
\alias{diagchk.ucarima}
\alias{diagchk}
\alias{diagchk.um}
\title{Diagnostic checking}
\usage{
\method{diagchk}{ssm}(mdl, lag.max = NULL, lags.at = NULL, freq.at = NULL, std = TRUE, ...)

\method{diagchk}{ucarima}(mdl, ...)

diagchk(mdl, ...)

\method{diagchk}{um}(
  mdl,
  z = NULL,
  method = c("exact", "cond"),
  lag.max = NULL,
  lags.at = NULL,
  freq.at = NULL,
  std = TRUE,
  envir = NULL,
  ...
)
}
\arguments{
\item{mdl}{an object of class \code{um}.}

\item{lag.max}{integer; maximum number of lags for ACF/PACF.}

\item{lags.at}{numeric vector; specific lags in ACF/PACF plots.}

\item{freq.at}{numeric vector; specific frequencies in (cum) periodogram plot.}

\item{std}{logical; if TRUE standardized residuals are used.}

\item{...}{additional arguments.}

\item{z}{optional, an object of class \code{ts}.}

\item{method}{character; "exact" or "conditional" residuals.}

\item{envir}{environment in which the function arguments are evaluated.
If NULL the calling environment of this function will be used.}
}
\description{
For objects of class \code{ucarima}, this method calls \code{diagchk.um}
internally to perform diagnostic checking.

\code{diagchk} displays tools for diagnostic checking.
}
\examples{

# Local level model
b <- 1
C <- as.matrix(1)
ssm1 <- ssm(Nile, b, C, S = diag(c(irr = 15127.7, lvl = 1453.2)))
diagchk(ssm1)
z <- AirPassengers
airl <- um(z, i = list(1, c(1,12)), ma = list(1, c(1,12)), bc = TRUE)
diagchk(airl)

}
