% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sem_search_corpus.R
\name{sem_search_corpus}
\alias{sem_search_corpus}
\title{NLP Search Corpus}
\usage{
sem_search_corpus(
  tif,
  text_hierarchy = c("doc_id", "paragraph_id", "sentence_id"),
  search,
  context_size = 0,
  is_inline = FALSE,
  highlight = c("<b>", "</b>"),
  cores = 1
)
}
\arguments{
\item{tif}{A data frame or data.table containing the text corpus.}

\item{text_hierarchy}{A character vector indicating the column(s) by which to group the data.}

\item{search}{The search pattern or query.}

\item{context_size}{Numeric, default 0. Specifies the context size, in sentences, around the found patterns.}

\item{is_inline}{Logical, default FALSE. Indicates if the search should be inline.}

\item{highlight}{A character vector of length two, default c('<b>', '</b>').
Used to highlight the found patterns in the text.}

\item{cores}{Numeric, default 1. The number of cores to use for parallel processing.}
}
\value{
A data.table with the search results.
}
\description{
Searches a text corpus for specified patterns, with support for parallel processing.
}
\examples{
tif <- data.frame(doc_id = c('1', '1', '2'),
                  sentence_id = c('1', '2', '1'),
                  text = c("Hello world.",
                           "This is an example.",
                           "This is a party!"))
sem_search_corpus(tif, search = 'This is', text_hierarchy = c('doc_id', 'sentence_id'))


}
