% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/td_tests.R
\name{td_tests}
\alias{td_tests}
\title{Tests of independence and uniformity for terminal digits in a data frame}
\usage{
td_tests(
  data,
  variable,
  decimals,
  group = NULL,
  reps = 10000,
  test = "Chisq",
  tolerance = 64 * .Machine$double.eps
)
}
\arguments{
\item{data}{A data frame}

\item{variable}{A numeric variable. Tests for terminal digits are performed on this variable.}

\item{decimals}{an integer specifying the number of decimals. This can be zero if the terminal digit is
not a decimal.}

\item{group}{A variable used to group the primary variable such that
p-values are calculated separately for each group. The default is set to NULL in which case
p-values are simply calculated for the whole data set.}

\item{reps}{an integer specifying the number of Monte Carlo simulations. The default
is set to 10,000.}

\item{test}{a string specifying the test of independence. The default is Pearson's
chi-squared statistic ("Chisq"). Also available is the log-likelihood ratio
statistic ("G2"), the Freeman-Tukey statistic ("FT"), and the Root-mean-square
statistic ("RMS").}

\item{tolerance}{sets an upper bound for rounding errors when evaluating
whether a statistic for a simulation is greater than or equal to the
statistic for the observed data. The default is identical to the tolerance
set for simulations in the \code{chisq.test} function from the \code{stats}
package in R.}
}
\value{
A data frame containing the following components:

\item{statistic}{the value of the test statistic}
\item{p_value_independence}{the simulated p-value for the test of independence}
\item{P_value_uniformity}{the simulated p-value for the test of uniformity (chi-squared GOF)}
\item{p_value_independence_fdr}{the simulated p-value for the test of independence adjusted via the
false discovery rate (if the \code{group} variable is specified)}
\item{P_value_uniformity}{the simulated p-value for the test of uniformity (chi-squared GOF)
adjusted via the false discovery rate (if the \code{group} variable is specified)}
}
\description{
The function \code{td_tests()} is a wrapper which applies the functions\code{td_independence()} and
\code{td_uniformity} to a data frame. When a \code{group} is specified, tests are conducted separated
for each group. P-values and p-values adjusted by the false discovery rate (Benjamini
and Hochberg, 1995) are reported.
}
\examples{

td_tests(decoy, weight, decimals = 2, group = subject, reps = 1000)

}
\references{
Benjamini, Y., and Hochberg, Y. (1995). Controlling the false discovery rate: a practical and powerful approach to multiple testing. Journal of the Royal Statistical Society Series B, 57, 289–300. doi: 10.1111/j.2517-6161.1995.tb02031.x. https://www.jstor.org/stable/2346101.
}
