% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vld.R
\name{vld_term}
\alias{vld_term}
\alias{vld_term_rcrd}
\title{Validate Term or Term Record}
\usage{
vld_term(x, validate = "complete")

vld_term_rcrd(x, validate = "complete")
}
\arguments{
\item{x}{The object.}

\item{validate}{A string specifying the level of the validation.
The possible values in order of increasing strictness
are 'class', 'valid', 'consistent' and 'complete'.}
}
\value{
A flag indicating whether the condition was met.
}
\description{
Validates the elements of a term or term_rcrd vector.
}
\details{
Internal validity of a term can be checked on three levels:
\itemize{
\item \code{"valid"} checks that all terms are of the form
\code{x}, \verb{x[#]}, \verb{x[#,#]} etc. where \code{x} is an identifier
and \verb{#} are positive integers.
\item \code{"consistent"} checks that all terms are addressed
with the same dimensionality; the terms \code{x[1]} and \code{x[2,3]}
are inconsistent.
\item \code{"complete"} checks that the values span all possible values
across all dimensions; if \code{x[3,4]} exist, the vector must
contain at least 11 more terms to be consistent
(\code{x[1,1]} to \code{x[1,4]}, \code{x[2,1]} to \code{x[2,4]} and
\code{x[3,1]} to \code{x[3,3]}).
}

Missing values are ignored as are duplicates and order.
}
\section{Functions}{
\itemize{
\item \code{vld_term_rcrd()}: Validate Term Record

}}
\examples{
# vld_term
vld_term(c("x[2]", "x[1]"))
vld_term(term("x[2]", "x[1]"))

# vld_term_rcrd
vld_term_rcrd(c("x[2]", "x[1]"))
vld_term_rcrd(term_rcrd("x[2]", "x[1]"))
}
\seealso{
\code{\link[=chk_term]{chk_term()}}

Other valid: 
\code{\link{valid_term}()}

Other valid: 
\code{\link{valid_term}()}
}
\concept{valid}
