% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chooseClusteringSize.R
\name{chooseClusteringSize}
\alias{chooseClusteringSize}
\title{Select the clustering size for order-3 sparse tensor clustering via BIC}
\usage{
chooseClusteringSize(
  x,
  k,
  r,
  l,
  lambda = 0,
  sim.times = 1,
  method = "L0",
  n.cores = NULL
)
}
\arguments{
\item{x}{a three-dimensional array}

\item{k}{a vector, the possible numbers of clusters at mode 1}

\item{r}{a vector, the possible numbers of clusters at mode 2}

\item{l}{a vector, the possible numbers of clusters at mode 3}

\item{lambda}{a numeric value, regularization coefficient}

\item{sim.times}{the number of simulation replicates when performing clustering}

\item{method}{two options: "L0", "L1". "L0" indicates L0 penalty, and "L1" indicates Lasso penalty}

\item{n.cores}{the number of cores in parallel implementation}
}
\value{
a list   

\code{estimated_krl} a 1*3 matrix consisting of the estimated clustering size  

\code{BIC} a vector consisting of the BIC value for all combinations of clustering sizes
}
\description{
Select the clustering size for three-way clustering. The function searches over a range of clustering sizes and outputs the one that minimizes BIC. The clustering size (\eqn{d_1}, \eqn{d_2}, \eqn{d_3}) is a length-3 vector consisting of the number of clusters in each mode.
}
