% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bg_by_date.R
\name{bg_by_date}
\alias{bg_by_date}
\title{Function to obtain environmental background organized by date}
\usage{
bg_by_date(
  this_species,
  buffer_ngbs = NULL,
  buffer_distance = 1000,
  n_bg = 50000,
  process_ngbs_by = 100
)
}
\arguments{
\item{this_species}{An object of class sp.temporal.env representing species
occurrence data organized by date. See \code{\link[tenm]{ex_by_date}}.}

\item{buffer_ngbs}{Number of pixel neighbors used to build the buffer around
each occurrence point.}

\item{buffer_distance}{Distance (in the same units as raster layers) used to
create a buffer around occurrence points to sample background data.}

\item{n_bg}{Number of background points to sample.}

\item{process_ngbs_by}{Numeric parameter to improve memory management.
It process neighbor cells by a quantity specified by the user.}
}
\value{
An object of class sp.temporal.bg containing background data
organized by date. The object is a list with the following components:
\itemize{
\item "bg_df": A data.frame with columns for longitude, latitude, year,
layer_date, layer_path, cell_ids_year, and environmental information.
\item Other metadata relevant to background sampling.
}
}
\description{
Function to retrieve background data from occurrence records.
The background data is organized as a function of the dated
environmental data.
}
\details{
This function retrieves background data around species occurrence points,
sampled based on the dated environmental data provided in \code{this_species}.
Background points are sampled within a buffer around each occurrence point.
The function returns an object of class sp.temporal.bg, which contains
background data organized by date. This object is the input of the function
\code{\link[tenm]{tenm_selection}}.
}
\examples{
\donttest{
library(tenm)
data("abronia")
tempora_layers_dir <- system.file("extdata/bio",package = "tenm")
abt <- tenm::sp_temporal_data(occs = abronia,
                              longitude = "decimalLongitude",
                              latitude = "decimalLatitude",
                              sp_date_var = "year",
                              occ_date_format="y",
                              layers_date_format= "y",
                              layers_by_date_dir = tempora_layers_dir,
                              layers_ext="*.tif$")
abtc <- tenm::clean_dup_by_date(abt,threshold = 10/60)
#This code is for running in parallel
future::plan("multisession",workers=2)
abex <- tenm::ex_by_date(this_species = abtc,train_prop=0.7)
abbg <- tenm::bg_by_date(this_species = abex,
                         buffer_ngbs=10,n_bg=50000)
future::plan("sequential")
}
}
