% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eye.R
\name{eye}
\alias{eye}
\title{Automated Approach for Interpreting the Hill-Plot}
\usage{
eye(data, ws = 0.01, epsilon = 0.3, h = 0.9)
}
\arguments{
\item{data}{vector of sample data}

\item{ws}{size of the moving window. \code{Default} is one percent of the data}

\item{epsilon}{size of the range in which the estimates can vary}

\item{h}{percentage of data inside the moving window that should lie in the tolerable range}
}
\value{
\item{k0}{optimal number of upper order statistics, i.e. number of exceedances or data in the tail}
\item{threshold}{the corresponding threshold}
\item{tail.index}{the corresponding tail index by plugging in \code{k0} into the hill estimator}
}
\description{
An Implementation of the so called Eye-balling Technique proposed in Danielsson et al. (2016)
}
\details{
The procedure searches for a stable region in the Hill-Plot by defining a moving window. Inside this window the estimates of the Hill estimator with respect to \code{k} have to be in a pre-defined range around the first estimate within this window. It is sufficient to claim that only \code{h} percent of the estimates within this window lie in this range. The smallest \code{k} that accomplishes this is then the optimal number of upper order statistics, i.e. data in the tail.
}
\examples{
data(danish)
eye(danish)
}
\references{
Danielsson, J. and Ergun, L.M. and de Haan, L. and de Vries, C.G. (2016). Tail Index Estimation: Quantile Driven Threshold Selection.
}
