% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{pauc}
\alias{pauc}
\title{Power-adjustment based on non-parametric estimation of the ROC curve}
\usage{
pauc(stat_h0, stat_ha, target_range_lower, target_range_upper)
}
\arguments{
\item{stat_h0}{simulated test statistics under the null hypothesis.}

\item{stat_ha}{simulated test statistics under the alternative hypothesis.}

\item{target_range_lower}{the lower end of the size range.}

\item{target_range_upper}{the upper end of the size range.}
}
\value{
the adjusted power.
}
\description{
It is common to use Monte Carlo experiments to evaluate the performance of
hypothesis tests and compare the empirical power among competing
tests. High power is desirable but difficulty arises when the actual sizes of
competing tests are not comparable. A possible way of tackling this issue is
to adjust the empirical power according to the actual size. This function
implements the "method 2: non-parametric estimation of the ROC curve" in
Lloyd (2005). For more details, please refer to the paper.
}
\examples{
stath0 <- rnorm(100)
statha <- rnorm(100, mean=1)
pauc(stath0, statha, 0.01, 0.1)
}
\references{
Lloyd, C. J. (2005). Estimating test power adjusted for size. Journal of Statistical Computation and Simulation, 75(11):921-933.
}
