% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{boot_test}
\alias{boot_test}
\title{Bootstrap_t test for two-sample comparisons}
\usage{
boot_test(x1, x2, B = 1000, alternative = "greater")
}
\arguments{
\item{x1}{the first sample.}

\item{x2}{the second sample.}

\item{B}{number of resampling rounds. Default value is 1000.}

\item{alternative}{the alternative hypothesis: "greater" for upper-tailed, "less" for lower-tailed, and "two.sided" for two-sided alternative.}
}
\value{
the p-value of the bootstrap_t test.
}
\description{
This function provides bootstrap approximation to the sampling distribution of the the
Welch's t-statistic
}
\examples{
x1 <- rnorm(100, 0, 1)
x2 <- rnorm(100, 0.5, 2)
boot_test(x1, x2)
}
