% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulated_data.R
\docType{data}
\name{simulated_data}
\alias{simulated_data}
\title{Simulated data with known SACE}
\format{A data frame with 5000 observations and 7 variables. \code{Z}, \code{A}, \code{Y}, \code{S} are 1-dimensional, and \code{X} is 3-dimensional. The variables are as follows:
\describe{
 \item{Z}{Binary treatment}
 \item{X.X1}{A factor covariate with 2 levels (1 and -1)}
 \item{X.V2}{A continuous covariate}
 \item{X.V3}{A contunuous covariate}
 \item{A}{The substitution variable which is continuous}
 \item{Y}{The continuous outcome. \code{NA} where \eqn{S = 0}}
 \item{S}{The survival indicator. \code{1} means survival and \code{0} means death.}
}}
\source{
The dataset is generated by the simulation design of \cite{Wang et al. 2017} with \eqn{\delta_1 = 1} and \eqn{\delta_0 = 1}, which allows confounding between \code{Z} and \code{Y} caused by \code{X}, and confounding between \code{S} and \code{Y} caused by \code{X}.
}
\description{
This simulated dataset is to illustrate how to use \link[tbd]{sace} to estimate the SACE, and compare it with other naive methods. In this simulated data, by design, there is confounding between \code{Z} and \code{Y} caused by \code{X}, and confounding between \code{S} and \code{Y} caused by \code{X}.
}
\references{
Linbo Wang, Xiao-Hua Zhou, Thomas S. Richardson; Identification and estimation of causal effects with outcomes truncated by death, Biometrika, Volume 104, Issue 3, 1 September 2017, Pages 597-612, \url{https://doi.org/10.1093/biomet/asx034}
}
\keyword{datasets}

