% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_workspace.R
\name{tar_workspace}
\alias{tar_workspace}
\title{Load a locally saved workspace and seed for debugging.}
\usage{
tar_workspace(
  name,
  envir = parent.frame(),
  packages = TRUE,
  source = TRUE,
  script = targets::tar_config_get("script"),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{name}{Symbol, name of the target whose workspace to read.}

\item{envir}{Environment in which to put the objects.}

\item{packages}{Logical, whether to load the required packages
of the target.}

\item{source}{Logical, whether to run \verb{_targets.R} to load user-defined
global object dependencies into \code{envir}. If \code{TRUE}, then \code{envir}
should either be the global environment or inherit from the
global environment.}

\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[=tar_script]{tar_script()}},
\code{\link[=tar_config_get]{tar_config_get()}}, and \code{\link[=tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
This function returns \code{NULL}, but it does load
the target's required packages, as well as multiple objects
into the environment (\code{envir} argument) in order to replicate the
workspace where the error happened. These objects include
the global objects at the time \code{\link[=tar_make]{tar_make()}} was called and the
dependency targets. The random number generator seed for the
target is also assigned with \code{\link[=tar_seed_set]{tar_seed_set()}}.
}
\description{
Load the packages, environment, and random number generator
seed of a target.
}
\details{
If you activate workspaces through the \code{workspaces} argument
of \code{\link[=tar_option_set]{tar_option_set()}}, then under the circumstances you specify,
\code{targets} will save a special workspace file to a location in
in \verb{_targets/workspaces/}. The workspace file is a compact reference
that allows \code{tar_workspace()} to load the target's dependencies
and random number generator seed as long as the data objects
are still in the data store (usually files in \verb{_targets/objects/}).
When you are done debugging, you can remove the workspace files
using \code{tar_destroy(destroy = "workspaces")}.

If \code{tar_option_get("repository_meta")} is \code{"aws"} or \code{"gcp"}, then
\code{\link[=tar_make]{tar_make()}} uploads workspaces to the bucket and prefix provided.
Download one of these workspaces with \code{\link[=tar_workspace_download]{tar_workspace_download()}}.
Downloaded workspaces can be loaded the usual way with
\code{\link[=tar_workspace]{tar_workspace()}}, and you should see them in
character vector returned by \code{\link[=tar_workspaces]{tar_workspaces()}}.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tmp <- sample(1)
tar_script({
  library(targets)
  library(tarchetypes)
  list(
    tar_target(x, "loaded"),
    tar_target(y, stop(x))
  )
}, ask = FALSE)
# The following code throws an error for demonstration purposes.
try(tar_make())
exists("x") # Should be FALSE.
tail(.Random.seed) # for comparison to the RNG state after tar_workspace(y)
tar_workspace(y)
exists("x") # Should be TRUE.
print(x) # "loaded"
# Should be different: tar_workspace() runs
# tar_seed_set(tar_meta(y, seed)$seed)
tail(.Random.seed)
})
}
}
\seealso{
Other debug: 
\code{\link{tar_load_globals}()},
\code{\link{tar_traceback}()},
\code{\link{tar_workspace_download}()},
\code{\link{tar_workspaces}()}
}
\concept{debug}
