% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnorm_tailplot.R
\name{lnorm_tail}
\alias{lnorm_tail}
\title{Estimate of tail functional s and confidence intervals for s and sigma}
\usage{
lnorm_tail(
  x,
  u,
  confint = FALSE,
  method = c("unbiased", "bootstrap", "jackknife"),
  R = 1000,
  conf.level = 0.95
)
}
\arguments{
\item{x}{a vector containing the sample data.}

\item{u}{the threshold for the computation of s.}

\item{confint}{a boolean value indicating whether the confidence interval should be computed.}

\item{method}{the method used for computing the confidence intervals (options include unbiased variance estimator, jackknife, and bootstrap).}

\item{R}{the number of the bootstrap replicates.}

\item{conf.level}{the confidence level for the interval.}
}
\value{
A matrix containing:
\item{threshold}{The value of the threshold u.}
\item{s.estimate}{Estimate of the tail functional s.}
\item{s.ci1}{The lower bound of the confidence interval for s (if \code{confint = TRUE}).}
\item{s.ci2}{The upper bound of the confidence interval for s (if \code{confint = TRUE}).}
\item{sigma}{Estimate of the scale parameter under a lognormal model.}
\item{sigma.ci1}{The lower bound of the confidence interval for sigma (if \code{confint = TRUE}).}
\item{sigma.ci2}{The upper bound of the confidence interval for sigma (if \code{confint = TRUE}).}
}
\description{
This function computes the estimate of \eqn{s} and the associated confidence interval for \eqn{s} as well as the standard deviation sigma on the log-scale of the lognormal distribution. Three methods are implemented to compute the confidence intervals: a method based on the unbiased variance estimators of the underlying U-statistics and two resampling methods (jackknife and bootstrap).
}
\details{
The function \eqn{s}, defined by
\deqn{
  s(u) = \mathbb{E}\!\left[
    \frac{|X_{1} - X_{2}|}{X_{1} + X_{2}} \;\middle|\; X_{1}\,X_{2} > u
  \right], 
}
where \eqn{X_1,X_2} are independent and identically distributed (i.i.d.) positive random variables, takes a constant value if and only if \eqn{X_1} follows a lognormal distribution.
Thus, \eqn{s} can be used to detect distributions with lognormal tails. The characterization of the lognormal distribution is based on the work of Mosimann (1970).
This function estimates \eqn{s(u)} using U-statistics, similarly as in Iwashita and Klar (2024).
}
\examples{
x = rlnorm(1e3, 2, 2)
u = round( quantile(x, 0.98) )
lnorm_tail(x, u, confint = FALSE)


}
\references{
Mosimann, J. E. (1970). Size allometry: size and shape variables with characterizations of the lognormal and generalized gamma distributions. Journal of the American Statistical Association, 65(330):930–945.
\doi{https://doi.org/10.2307/2284599}

Iwashita, T. & Klar, B. (2024). A gamma tail statistic and its asymptotics. Statistica Neerlandica 78:2, 264-280.
\doi{https://doi.org/10.1111/stan.12316}
}
