% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimationML.R
\name{AsymVarMaxLinear}
\alias{AsymVarMaxLinear}
\title{Asymptotic variance matrix for the max-linear model.}
\usage{
AsymVarMaxLinear(indices, par, Bmatrix = NULL)
}
\arguments{
\item{indices}{A \eqn{q} x \eqn{d} matrix containing at least 2 non-zero elements per row, representing the values in which we will evaluate the stable tail dependence function.}

\item{par}{The parameter vector.}

\item{Bmatrix}{A function that converts the parameter vector theta to a parameter matrix B. If \code{NULL}, then a simple 2-factor model is assumed.}
}
\value{
A \code{q} by \code{q} matrix.
}
\description{
Computes the asymptotic variance matrix for the max-linear model, estimated using the weighted least squares estimator.
}
\examples{
indices <- selectGrid(c(0,0.5,1), d = 3, nonzero = 3)
AsymVarMaxLinear(indices, par = c(0.1,0.55,0.75))
}
\references{
Einmahl, J.H.J., Kiriliouk, A., and Segers, J. (2018). A continuous updating weighted least squares estimator of tail dependence in high dimensions. Extremes 21(2), 205-233.
}
\seealso{
\code{\link{selectGrid}}
}
