% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutoff.R
\name{pos_anyroi}
\alias{pos_anyroi}
\title{Dichotomize participants based on ROI cutoff values}
\usage{
pos_anyroi(modelstats, cutoff)
}
\arguments{
\item{modelstats}{SUVR or DVR data for group of participants from batch_tm()}

\item{cutoff}{cutoffs for ROIs as from cutoff_aiz()}
}
\value{
data.frame of participants and positive/negative status
}
\description{
Aizenstein et al. (2008) proposed a standardized method of calculating PIB+ 
cutoff values to classify participants as PIB+ or PIB-. They used the DVR 
from 7 ROIs associated with amyloid deposition. This function takes the 
ROI-based cutoff values, e.g. from cutoff_aiz(), and returns a table 
specifying which participants are positive, i.e. which have at least one ROI
greater than the cutoff.
}
\references{
Aizenstein HJ, Nebes RD, Saxton JA, et al. 2008. Frequent amyloid 
deposition without significant cognitive impairment among the elderly. 
Arch Neurol 65: 1509-1517.
}
\seealso{
Other Cutoff functions: 
\code{\link{cutoff_aiz}()}
}
\concept{Cutoff functions}
