% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.ref_Logan}
\alias{plot.ref_Logan}
\title{Non-invasive reference Logan plot}
\usage{
\method{plot}{ref_Logan}(x, ...)
}
\arguments{
\item{x}{Reference Logan model data object from DVR_ref_Logan()}

\item{...}{Additional parameters than can be passed to plotting function}
}
\value{
No return
f <- system.file("extdata", "AD06.tac", package="tacmagic")
fv <- system.file("extdata", "AD06_TAC.voistat", package="tacmagic")
AD06_tac <- load_tac(f, format="PMOD")
AD06_volume <- load_vol(fv, format="voistat")
AD06 <- tac_roi(tac=AD06_tac, volumes=AD06_volume, ROI_def=roi_ham_pib(),  
                merge=FALSE, PVC=FALSE)  
AD06_DVR_fr <- DVR_ref_Logan(AD06, target="frontal", ref="cerebellum",
                             k2prime=0.2, t_star=0) 
plot(AD06_DVR_fr)
}
\description{
This plots the non-invasive Logan plot.
}
\seealso{
Other Logan plot functions: 
\code{\link{DVR_all_ref_Logan}()},
\code{\link{DVR_ref_Logan}()},
\code{\link{dvr}()}
}
\concept{Logan plot functions}
