% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batches.R
\name{batch_tm}
\alias{batch_tm}
\title{Calculate one or more models for a batch of participants}
\usage{
batch_tm(all_tacs, models, custom_model = NULL, ...)
}
\arguments{
\item{all_tacs}{A list by participant, of tac data (load_batch())}

\item{models}{A vector of names of the models to calculate}

\item{custom_model}{A function that can be run like other models (advanced)}

\item{...}{The arguments that get passed to the specified models/custom model,
many are required; please check with model desired.}
}
\value{
A table of SUVR values for the specified ROIs for all participants
}
\description{
For a list of tac data (from load_batch) this calculates specified models
and saves in a tidy data.frame. Current model options are "SUVR", "Logan".
}
\details{
For further details about how the models are calculated, see the individual
functions that they rely on. "SUVR" uses suvr(), "Logan" uses
DVR_all_ref_Logan().
}
\examples{
participants <- c(system.file("extdata", "AD06.tac", package="tacmagic"),
                  system.file("extdata", "AD07.tac", package="tacmagic"),
                  system.file("extdata", "AD08.tac", package="tacmagic"))

tacs <- batch_load(participants, tac_file_suffix="")

# Keeps only the ROIs without partial-volume correction (PMOD convention)
tacs <- lapply(tacs, split_pvc, FALSE)

batch <- batch_tm(tacs, models=c("SUVR", "Logan"), ref="Cerebellum_r",
                  SUVR_def=c(3000,3300,3600), k2prime=0.2, t_star=23)

}
\seealso{
Other Batch functions: 
\code{\link{batch_load}()},
\code{\link{batch_voistat}()}
}
\concept{Batch functions}
