% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableMatrix.R
\name{rbind.tableList}
\alias{rbind.tableList}
\title{Combine by rows}
\usage{
\method{rbind}{tableList}(..., use.names = TRUE, fill = FALSE)
}
\arguments{
\item{...}{\code{tableList} objects.}

\item{use.names}{Passed to rbind.data.table.}

\item{fill}{Passed to rbind.data.table.}
}
\value{
\code{tableList} object.
}
\description{
\code{tableList} method, binds rows of \code{tableList} objects.
}
\examples{

data(images8By8)
data(images10By10)

# Create tableList objects from images8By8[,1:3] and images10By10[,1:3]
TL1 <- tableList(images8By8[,1:3])
TL2 <- tableList(images10By10[,1:3])

# Bindind rows of two tableList objects
rbind(TL1, TL2)

}
