% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccm.R
\name{ccm}
\alias{ccm}
\alias{ccm,data.frame-method}
\title{convergent cross mapping}
\usage{
\S4method{ccm}{data.frame}(
  data,
  cause,
  effect,
  libsizes = NULL,
  E = 3,
  tau = 1,
  k = E + 1,
  theta = 1,
  algorithm = "simplex",
  lib = NULL,
  pred = NULL,
  dist.metric = "L1",
  dist.average = TRUE,
  threads = length(pred),
  parallel.level = "low",
  bidirectional = TRUE,
  progressbar = TRUE
)
}
\arguments{
\item{data}{observation data.}

\item{cause}{name of causal variable.}

\item{effect}{name of effect variable.}

\item{libsizes}{(optional) number of time points used.}

\item{E}{(optional) embedding dimensions.}

\item{tau}{(optional) step of time lags.}

\item{k}{(optional) number of nearest neighbors.}

\item{theta}{(optional) weighting parameter for distances, useful when \code{algorithm} is \code{smap}.}

\item{algorithm}{(optional) prediction algorithm.}

\item{lib}{(optional) libraries indices.}

\item{pred}{(optional) predictions indices.}

\item{dist.metric}{(optional) distance metric (\code{L1}: Manhattan, \code{L2}: Euclidean).}

\item{dist.average}{(optional) whether to average distance.}

\item{threads}{(optional) number of threads to use.}

\item{parallel.level}{(optional) level of parallelism, \code{low} or \code{high}.}

\item{bidirectional}{(optional) whether to examine bidirectional causality.}

\item{progressbar}{(optional) whether to show the progress bar.}
}
\value{
A list
\describe{
\item{\code{xmap}}{cross mapping results}
\item{\code{varname}}{names of causal and effect variables}
\item{\code{bidirectional}}{whether to examine bidirectional causality}
}
}
\description{
convergent cross mapping
}
\examples{
sim = logistic_map(x = 0.4,y = 0.4,step = 45,beta_xy = 0.5,beta_yx = 0)
ccm(sim,"x","y",libsizes = seq(5,45,5),E = 10,k = 7,threads = 1)

}
\references{
Sugihara, G., May, R., Ye, H., Hsieh, C., Deyle, E., Fogarty, M., Munch, S., 2012. Detecting Causality in Complex Ecosystems. Science 338, 496–500.
}
