% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idinput.R
\name{idinput}
\alias{idinput}
\title{function to generate input singals (rgs/rbs/prbs/sine)}
\usage{
idinput(n, type = "rgs", band = c(0, 1), levels = c(-1, 1))
}
\arguments{
\item{n}{integer length of the input singal to be generated}

\item{type}{the type of input signal to be generated. 
'rgs' - generates random gaussian signal
'rbs' - generates random binary signal
'prbs' - generates pseudorandom binary signal
'sine' - generates a signal that is a sum of sinusoids

Default value is type='rgs'}

\item{band}{determines the frequency content of the signal. 
For type='rbs'/'sine'/,  band = [wlow,whigh]
which specifies the lower and the upper bound of the passband frequencies(expressed as fractions of Nyquist frequency). Default is c(0,1)
For type='prbs', band=[0,B]
where B is such that the singal is constant over 1/B (clock period). Default is c(0,1)}

\item{levels}{row vector defining the input level. It is of the form 
levels=c(minu, maxu)
For 'rbs','prbs', 'sine', the generated signal always between minu and maxu.
For 'rgs', minu=mean value of signal minus one standard deviation and maxu=mean value of signal plus one standard deviation

Default value is levels=c(-1,1)}
}
\description{
\code{idinput} is a function for generating input signals (rgs/rbs/prbs/sine) for identification purposes
}

