% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{compare}
\alias{compare}
\title{Compare the measured output and the predicted output(s)}
\usage{
compare(data, nahead = 1, ...)
}
\arguments{
\item{data}{validation data in the form of an \code{idframe} object}

\item{nahead}{number of steps ahead at which to predict (Default:1). For infinite-
step ahead predictions, supply \code{Inf}.}

\item{\ldots}{models whose predictions are to be compared}
}
\description{
Plots the output predictions of model(s) superimposed over validation data, 
data, for comparison.
}
\examples{
data(arxsim)
mod1 <- arx(arxsim,c(1,2,2))
mod2 <- oe(arxsim,c(2,1,1))
compare(arxsim,nahead=Inf,mod1,mod2)

}
\seealso{
\code{\link{predict.estpoly}} for obtaining model predictions
}

