% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estpoly.R
\name{armax}
\alias{armax}
\title{Estimate ARMAX Models}
\usage{
armax(x, order = c(0, 1, 1, 0), init_sys = NULL, intNoise = FALSE,
  options = optimOptions())
}
\arguments{
\item{x}{an object of class \code{idframe}}

\item{order}{Specification of the orders: the four integer components 
(na,nb,nc,nk) are the order of polynolnomial A, order of polynomial B 
+ 1, order of the polynomial C,and the input-output delay respectively}

\item{init_sys}{Linear polynomial model that configures the initial parameterization.
Must be an ARMAX model. Overrules the \code{order} argument}

\item{intNoise}{Logical variable indicating whether to add integrators in
the noise channel (Default=\code{FALSE})}

\item{options}{Estimation Options, setup using \code{\link{optimOptions}}}
}
\value{
An object of class \code{estpoly} containing the following elements:
 \item{sys}{an \code{idpoly} object containing the 
   fitted ARMAX coefficients}
 \item{fitted.values}{the predicted response}
 \item{residuals}{the residuals}
 \item{input}{the input data used}
 \item{call}{the matched call}
 \item{stats}{A list containing the following fields: \cr
     \code{vcov} - the covariance matrix of the fitted coefficients \cr
     \code{sigma} - the standard deviation of the innovations}
 \item{options}{Option set used for estimation. If no 
   custom options were configured, this is a set of default options}
 \item{termination}{Termination conditions for the iterative
    search used for prediction error minimization:
     \code{WhyStop} - Reason for termination \cr
     \code{iter} - Number of Iterations \cr
     \code{iter} - Number of Function Evaluations }
}
\description{
Fit an ARMAX model of the specified order given the input-output data
}
\details{
SISO ARMAX models are of the form 
\deqn{
   y[k] + a_1 y[k-1] + \ldots + a_{na} y[k-na] = b_{nk} u[k-nk] + 
   \ldots + b_{nk+nb} u[k-nk-nb] + c_{1} e[k-1] + \ldots c_{nc} e[k-nc]
   + e[k] 
}
The function estimates the coefficients using non-linear least squares 
(Levenberg-Marquardt Algorithm)
\cr
The data is expected to have no offsets or trends. They can be removed 
using the \code{\link{detrend}} function.
}
\examples{
data(armaxsim)
z <- dataSlice(armaxsim,end=1533) # training set
mod_armax <- armax(z,c(1,2,1,2))
mod_armax

}
\references{
Arun K. Tangirala (2015), \emph{Principles of System Identification: 
Theory and Practice}, CRC Press, Boca Raton. Sections 14.4.1, 21.6.2
}

