% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_citation.R
\name{format_citation}
\alias{format_citation}
\title{Format a citation}
\usage{
format_citation(
  data,
  details = TRUE,
  abstract = FALSE,
  add_html = FALSE,
  line_breaks = FALSE,
  ...
)
}
\arguments{
\item{data}{An object of class data.frame, list, or or bibliography.}

\item{details}{Logical: Should identifying information such as author names & journal titles be displayed? Defaults to TRUE.}

\item{abstract}{Logical: Should the abstract be shown (if available)? Defaults to FALSE.}

\item{add_html}{Logical: Should the journal title be italicized using html codes? Defaults to FALSE.}

\item{line_breaks}{Either logical, stating whether line breaks should be added, or numeric stating how many characters should separate consecutive line breaks. Defaults to FALSE.}

\item{...}{any other arguments.}
}
\value{
Returns a string of length equal to length(data) that contains formatted citations.
}
\description{
This function takes an object of class data.frame, list, or bibliography and returns a formatted citation.
}
\examples{
roses <- c("@article{haddaway2018,
  title={ROSES RepOrting standards for Systematic Evidence Syntheses:
  pro forma, flow-diagram and descriptive summary of the plan and
  conduct of environmental systematic reviews and systematic maps},
  author={Haddaway, Neal R and Macura, Biljana and Whaley, Paul and Pullin, Andrew S},
  journal={Environmental Evidence},
  volume={7},
  number={1},
  pages={7},
  year={2018},
  publisher={Springer}
}")

tmp <- tempfile()
writeLines(roses, tmp)

citation <- read_ref(tmp)
format_citation(citation)
}
