% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_Error.R
\name{data.gen.affine}
\alias{data.gen.affine}
\title{Generate an affine error model.}
\usage{
data.gen.affine(nobs, a = 0, b = 1, ndim = 3, mu = 0, sd = 1)
}
\arguments{
\item{nobs}{The data length to be generated.}

\item{a}{intercept}

\item{b}{slope}

\item{ndim}{The number of potential predictors (default is 9).}

\item{mu}{mean of error term}

\item{sd}{standard deviation of error term}
}
\value{
A list of 2 elements: a vector of response (x), and a matrix of potential predictors (dp) with each column containing one potential predictor.
}
\description{
Generate an affine error model.
}
\examples{
# Affine error model from paper with 3 dummy variables
data.affine<-data.gen.affine(500)
plot.ts(cbind(data.affine$x,data.affine$dp))
}
\references{
McColl, K. A., Vogelzang, J., Konings, A. G., Entekhabi, D., Piles, M., & Stoffelen, A. (2014). Extended triple collocation: Estimating errors and correlation coefficients with respect to an unknown target. Geophysical Research Letters, 41(17), 6229-6236. doi:10.1002/2014gl061322
}
