% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw_augment.R
\name{sw_augment}
\alias{sw_augment}
\title{Augment data according to a tidied model}
\usage{
sw_augment(x, ...)
}
\arguments{
\item{x}{model or other R object to convert to data frame}

\item{...}{other arguments passed to methods}
}
\description{
Given an R statistical model or other non-tidy object, add columns to the
original dataset such as predictions, residuals and cluster assignments.
}
\details{
\code{sw_augment()} is a wrapper for \code{\link[broom:reexports]{broom::augment()}}. The benefit of \code{sw_augment}
is that it has methods for various time-series model classes such as
\code{HoltWinters}, \code{ets}, \code{Arima}, etc.

For non-time series, \code{sw_augment()} defaults to \code{\link[broom:reexports]{broom::augment()}}.
The only difference is that the return is a tibble.

Note that by convention the first argument is almost always \code{data},
which specifies the original data object. This is not part of the S3
signature, partly because it prevents rowwise_df_tidiers from
taking a column name as the first argument.
}
\seealso{
\code{\link[broom:reexports]{broom::augment()}}
}
