% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chull.R
\name{is_chull}
\alias{is_chull}
\alias{isChull}
\title{Points on Convex Hull}
\usage{
is_chull(x, y)

isChull(x, y)
}
\arguments{
\item{x}{A vector of x (or longitude) coordinates.}

\item{y}{A vector of y (or latitude) coordinates.}
}
\value{
A numerical vector of the same length as \code{x} and \code{y}. 
 \code{0} indicates that the corresponding location is not part of the convex 
 hull of the set. Values \code{>0} indicates that the corresponding location 
 is part of the convex hull, and each value corresponds to the order of the 
 locations along the convex hull polygon.
}
\description{
Given a set of locations, this function determines which 
 locations belongs to the convex hull (or envelope) of the set.
}
\examples{
x <- rnorm(25)
y <- rnorm(25, sd = 3)
is_chull(x, y)

}
\seealso{
\code{\link{chull_area}}, \code{\link{chull_perimeter}}
}
\author{
Simon Garnier, \email{garnier@njit.edu}
}
