% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs.r
\name{vec2ddc}
\alias{vec2ddc}
\alias{vec2dc}
\title{Transform a Vector into a Double-Coded Matrix}
\usage{
vec2ddc(x, limits = c(NA, NA))

vec2dc(x, limits = c(NA, NA))
}
\arguments{
\item{x}{A vector, either numeric or an ordered factor.}

\item{limits}{Numeric vector of length two specifying the limits (or "poles") of the underlying ordinal variable. If left unspecified (the default), then the minimum and maximum in \code{x} will be taken.}
}
\value{
A matrix with column names \code{-} and \code{+}.
}
\description{
A helper function for transforming a vector into a double-coded matrix.
}
\details{
Double coding, also called data doubling, is a way of indicating how the values of an ordinal variable relate to the lower and upper limits of the variable. Columns \code{-} and \code{+} express how close each (observed) value is to these respective limits.
}
\references{
Greenacre, M. (2014) Data doubling and fuzzy coding. In: J. Blasius and M. Greenacre (eds.) \emph{Visualization and verbalization of data}. Chapman and Hall/CRC, 239--253.
Greenacre, M. (2017) \emph{Correspondence analysis in practice, Third edition}. Boca Raton: Chapman and Hall/CRC, 201--208.
}
\seealso{
\code{\link{dat2ddc}}.
}
