% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs.r
\name{fast_nmf}
\alias{fast_nmf}
\alias{fast_nmf_KL}
\alias{fast_nmf_Fr}
\alias{fast_nmf_Al}
\title{Non-negative Matrix Factorization}
\usage{
fast_nmf(dat, k, type = "KL", tol = 1e-08)

fast_nmf_KL(dat, k, tol = 1e-08)

fast_nmf_Fr(dat, k, tol = 1e-08)

fast_nmf_Al(dat, k, tol = 1e-08)
}
\arguments{
\item{dat}{Input data: can be a table or a data frame (but the data frame must have only two columns).}

\item{k}{Numeric specification of the number of latent axes to compute.}

\item{type}{Character specification of the type of optimization: can in the current implementation be either \code{"KL"} for
the Kullback-Leibler divergence, \code{"Frobenius"} or \code{"euclidean"} (or abbreviations thereof) for the euclidean distance, or
\code{"ALS"} for alternating least squares.}

\item{tol}{Numeric specification of the convergence criterion.}
}
\value{
A list with components:
\item{\code{pos1} }{The coordinates of the first set of levels (\emph{viz.} the row levels of a frequency table).}
\item{\code{pos2} }{The coordinates of the second set of levels (\emph{viz.} the column levels of a frequency table).}
}
\description{
A fast procedure for non-negative matrix factorization.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\t", quote = "\"", encoding = "UTF-8",
   stringsAsFactors = FALSE)
nmf_SndT_Fra <- fast_nmf(SndT_Fra, k = 7)
nmf_SndT_Fra
}
\references{
Lee, D. D. and H. S. Seung (1999) Learning the parts of objects by non-negative matrix factorization. \emph{Nature} \strong{401}, 788--791.

Lee, D. D. and H. S. Seung (2001) Algorithms for non-negative matrix factorization. \emph{Advances in neural information processing systems}
  \strong{13}, 556--562.
}
