% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_labelling.R
\name{new_labelling}
\alias{new_labelling}
\alias{newLabelling}
\alias{fig}
\alias{tab}
\alias{eq}
\title{Reference figures, tables and equations in R Markdown documents}
\usage{
new_labelling(
  type = c("arabic", "roman"),
  string_html = paste0("<style>.++++-\%\%\%\%::after{content:\\"####\\"}</style>",
    "<span class=\\"figheader\\">Figure\\\\ ####: </span>@@@@"),
  string_latex = "@@@@",
  string_word = "[Figure\\\\ ####:]{#++++:\%\%\%\%} @@@@",
  string_ref_html = "<a class=\\"++++-\%\%\%\%\\" href=\\"#++++:\%\%\%\%\\"></a>",
  string_ref_latex = "\\\\ref{++++:\%\%\%\%}",
  string_ref_word = "[####](#++++:\%\%\%\%)",
  name = "fig"
)

newLabelling(
  type = c("arabic", "roman"),
  string_html = paste0("<style>.++++-\%\%\%\%::after{content:\\"####\\"}</style>",
    "<span class=\\"figheader\\">Figure\\\\ ####: </span>@@@@"),
  string_latex = "@@@@",
  string_word = "[Figure\\\\ ####:]{#++++:\%\%\%\%} @@@@",
  string_ref_html = "<a class=\\"++++-\%\%\%\%\\" href=\\"#++++:\%\%\%\%\\"></a>",
  string_ref_latex = "\\\\ref{++++:\%\%\%\%}",
  string_ref_word = "[####](#++++:\%\%\%\%)",
  name = "fig"
)

fig(
  caption = "",
  label = knitr::opts_current$get("label"),
  ref = NULL,
  reset = FALSE
)

tab(
  caption = "",
  label = knitr::opts_current$get("label"),
  ref = NULL,
  reset = FALSE
)

eq(label, ref, reset = FALSE)
}
\arguments{
\item{type}{The type of numbering (arabic or roman).}

\item{string_html}{The string prototyping the legend, with \verb{++++} being the
name (\code{fig} by default) \verb{@@} being a placeholder for the text, \verb{####} as a
placeholder for the number, or \verb{\%\%\%\%} as a placeholder for the label.}

\item{string_latex}{Idem for LaTeX.}

\item{string_word}{Idem for Word.}

\item{string_ref_html}{Idem for reference in HTML format.}

\item{string_ref_latex}{Idem for reference in LaTeX format.}

\item{string_ref_word}{Idem for reference in Word format.}

\item{name}{The name to use before the number, e.g., "Fig." to get "Fig. 1"
as cross-reference text for the first figure. If you provide \code{name = NULL},
only the number is produced.}

\item{caption}{The test of the caption.}

\item{label}{A short string uniquely identifying the item within the
collection. To set a label in and equation, give a name instead of a string.}

\item{ref}{The reference to the label.}

\item{reset}{If \code{TRUE}, the collection is reset. Useful if you want to
restart numbering at the beginning of each chapter.}
}
\value{
The function returns a caption if \verb{text =} is provided, or an anchor if it is
missing. If \verb{text=} contains a name, it returns a link.
Same for the \verb{label=} for \code{eq()}: if it is a text, a couple label + tag to
place inside display equations is produced, and if it is a name, a link is
provided. \code{\link[=new_labelling]{new_labelling()}} creates a new labelling function, which has the
same arguments as \code{\link[=fig]{fig()}}.
}
\description{
These functions return closures that allow for constructing a series of
numbered items and to reference them. The number is create the first time a
label is encountered, and provided again for further use of the same label.
}
\details{
A new labelling type is created using \code{\link[=new_labelling]{new_labelling()}} which is a function
factory (a function that creates functions).
}
\examples{
# These function are supposed to be used in an R Markdown document
# see the svSweave vignette
# Produce a caption that contains the required code to number and reference
# a figure in HTML documents
fig("A caption", label = "a_label")
# Produce a reference to that figure
fig$a_label
}
\author{
Philippe Grosjean
}
\concept{automatic numbering of items in documents}
\keyword{utilities}
