% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlg_form.R
\name{dlg_form}
\alias{dlg_form}
\alias{dlgForm}
\alias{dlg_form.gui}
\alias{dlg_form.textCLI}
\alias{dlg_form.nativeGUI}
\title{Modal dialog to fill a series of different fields.}
\usage{
dlg_form(
  form,
  title = "Fill the form",
  message = NULL,
  columns = 1,
  strip.type = TRUE,
  ...,
  gui = .GUI
)

dlgForm(
  form,
  title = "Fill the form",
  message = NULL,
  columns = 1,
  strip.type = TRUE,
  ...,
  gui = .GUI
)

\method{dlg_form}{gui}(
  form,
  title = "Fill the form",
  message = NULL,
  columns = 1,
  strip.type = TRUE,
  ...,
  gui = .GUI
)

\method{dlg_form}{textCLI}(
  form,
  title = "Fill the form",
  message = NULL,
  columns = 1,
  strip.type = TRUE,
  ...,
  gui = .GUI
)

\method{dlg_form}{nativeGUI}(
  form,
  title = "Fill the form",
  message = NULL,
  columns = 1,
  strip.type = TRUE,
  ...,
  gui = .GUI
)
}
\arguments{
\item{form}{Named list of default values, or list of possible items. Names
are the labels of corresponding entries in the dialog box, followed by an
indicator of the type of entry to place in the dialog box (see details).}

\item{title}{The title of the form.}

\item{message}{An optional message to display in the dialog box. Use
\verb{\\\\n} for line break, or provide a vector of character strings, one for
each line.}

\item{columns}{Arrange the entries on this number of columns (by row).}

\item{strip.type}{Do we strip the type from the names in results?}

\item{...}{Pass further arguments to methods.}

\item{gui}{The 'gui' object concerned by this dialog box.}
}
\value{
The modified 'gui' object is returned invisibly. Use its \code{gui$res}
component to get the list of returned fields.
}
\description{
A customizable form dialog box with checkboxes, entries, lists, etc.
}
\details{
The form content is defined by a named list. Items are default
values, or a list of possible items, e.g., for the combobox. Names are labels
displayed in front of each field in the form. Follow them by a code that
represents the type of entry you want to use:
\itemize{
\item \verb{:TXT} for simple (default) textual box,
\item \verb{:H} for hidden text (password),
\item \verb{:RO} for read-only text,
\item \verb{:NUM} for null of positive integers with up/down arrows,
\item \verb{:CHK} for checkbox: \code{TRUE} or \code{FALSE},
\item \verb{:CB} for read-only combobox,
\item \verb{:CBE} for editable combobox,
\item \verb{:FL} to select one existing file,
\item \verb{:MFL} to select multiple existing files,
\item \verb{:SFL} to select or create one file,
\item \verb{:DIR} to select a directory,
\item \verb{:CDIR} to select or create a directory,
\item \verb{:FN} to select font and font size,
\item \verb{:DT} to enter a date,
\item :CLR` to enter a RGB color,
\item :BTN` to create a button that execute some code,
\item \verb{:LBL} to add a label.
}

For the moment, the form dialog box is only supported on Linux. You have to
install \strong{yad} to get access to it. On Ubuntu, you do so by
\verb{sudo apt-get install yad}. For other system, look at the documentation.
}
\note{
\code{dlg_form()} can use strings with embedded quotes, but you have to
escape them (and need to double the backslash escape sign). Currently,
this is not done automatically, on the contrary to the other \code{dlg_xxx()}
functions!
}
\examples{
\dontrun{
# Ask a series of items at once in a dialog box
form <- list(
  "Name:TXT" = "John Smith",
  "Age:NUM" = 25,
  "Sex:CB" = c("male", "female"),
  "Married:CHK" = FALSE
)
dlg_form(form, "My data")$res
}
}
\seealso{
\code{\link[=dlg_input]{dlg_input()}}, \code{\link[=dlg_list]{dlg_list()}}
}
\concept{Modal dialog box}
\keyword{misc}
