% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_estimates.r
\name{bootstrap.estimates}
\alias{bootstrap.estimates}
\title{bootstrap.estimates}
\usage{
bootstrap.estimates(
  survey.data,
  survey.design,
  bootstrap.fn,
  estimator.fn,
  num.reps,
  weights = NULL,
  ...,
  summary.fn = NULL,
  verbose = TRUE,
  parallel = FALSE,
  paropts = NULL
)
}
\arguments{
\item{survey.data}{The dataset to use}

\item{survey.design}{A formula describing the design of the survey
(see Details below)}

\item{bootstrap.fn}{Name of the method to be used to take
bootstrap resamples}

\item{estimator.fn}{The name of a function which, given a dataset like
\code{survey.data} and arguments in \code{...},
will produce an estimate of interest}

\item{num.reps}{The number of bootstrap replication samples to draw}

\item{weights}{Weights to use in estimation (or \code{NULL}, if none)}

\item{...}{additional arguments which will be passed on to \code{estimator.fn}}

\item{summary.fn}{(Optional) Name of a function which, given the set of estimates
produced by \code{estimator.fn}, summarizes them. If not specified, all of
the estimates are returned in a list.}

\item{verbose}{If \code{TRUE}, produce lots of feedback about what is going on}

\item{parallel}{If \code{TRUE}, use the \code{plyr} library's \code{.parallel} argument to
produce bootstrap resamples and estimates in parallel}

\item{paropts}{If not \code{NULL}, additional arguments to pass along to the
parallelization routine}
}
\value{
If \code{summary.fn} is not specified, then return the list of estimates
produced by \code{estimator.fn}; if \code{summary.fn} is specified, then return
its output
}
\description{
Use a given bootstrap method to estimate sampling uncertainty from a given
estimator.
}
\details{
The formula describing the survey design should have the form
\code{~ psu_v1 + psu_v2 + ... + strata(strata_v1 + strata_v2 + ...)},
where \verb{psu_v1, ...} are the variables identifying primary sampling units (PSUs)
and \verb{strata_v1, ...} identifies the strata
}
\examples{

# example using a simple random sample

survey <- MU284.surveys[[1]]

estimator <- function(survey.data, weights) {
  plyr::summarise(survey.data,
                  T82.hat = sum(S82 * weights))
}

ex.mu284 <- bootstrap.estimates(
   survey.design = ~1,
   num.reps = 10,
   estimator.fn = estimator,
   weights='sample_weight',
   bootstrap.fn = 'srs.bootstrap.sample',
   survey.data=survey)

\dontrun{
idu.est <- bootstrap.estimates(
  ## this describes the sampling design of the
  ## survey; here, the PSUs are given by the
  ## variable cluster, and the strata are given
  ## by the variable region
  survey.design = ~ cluster + strata(region),
  ## the number of bootstrap resamples to obtain
  num.reps=1000,
  ## this is the name of the function
  ## we want to use to produce an estimate
  ## from each bootstrapped dataset
  estimator.fn="our.estimator",
  ## these are the sampling weights
  weights="indweight",
  ## this is the name of the type of bootstrap
  ## we wish to use
  bootstrap.fn="rescaled.bootstrap.sample",
  ## our dataset
  survey.data=example.survey,
  ## other parameters we need to pass
  ## to the estimator function
  d.hat.vals=d.hat,
  total.popn.size=tot.pop.size,
  y.vals="clients",
  missing="complete.obs")

}
}
